<?php
class AuthManager {
    
    public function login($username, $password) {
        if ($username === ADMIN_USERNAME && $password === ADMIN_PASSWORD) {
            session_start();
            $_SESSION['admin_logged_in'] = true;
            $_SESSION['admin_username'] = $username;
            $_SESSION['login_time'] = time();
            
            logError("Admin login successful: $username");
            return ['success' => true, 'message' => 'Login successful'];
        }
        
        logError("Failed login attempt: $username");
        return ['success' => false, 'message' => 'Invalid credentials'];
    }
    
    public function logout() {
        session_start();
        session_destroy();
        return ['success' => true, 'message' => 'Logged out successfully'];
    }
    
    public function isLoggedIn() {
        session_start();
        return isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true;
    }
    
    public function sendPasswordReset($email) {
        if ($email !== ADMIN_EMAIL) {
            return ['success' => false, 'message' => 'Email not found'];
        }
        
        // Generate reset token
        $token = bin2hex(random_bytes(32));
        $resetLink = "https://mage.lk/Dashboard/reset-password.php?token=$token";
        
        // In production, send actual email
        // For now, just log the reset link
        logError("Password reset requested for: $email, Reset link: $resetLink");
        
        // Here you would send the actual email
        // mail($email, "Password Reset", "Click here to reset: $resetLink");
        
        return ['success' => true, 'message' => 'Password reset link sent to your email'];
    }
    
    public function requireAuth() {
        if (!$this->isLoggedIn()) {
            http_response_code(401);
            echo json_encode(['success' => false, 'message' => 'Authentication required']);
            exit;
        }
    }
}
?>