<?php
require_once 'config.php';
require_once 'classes/AuthManager.php';

setCorsHeaders();

$auth = new AuthManager();
$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    $action = $input['action'] ?? '';
    
    switch ($action) {
        case 'login':
            $username = $input['username'] ?? '';
            $password = $input['password'] ?? '';
            $result = $auth->login($username, $password);
            break;
            
        case 'logout':
            $result = $auth->logout();
            break;
            
        case 'reset-password':
            $email = $input['email'] ?? '';
            $result = $auth->sendPasswordReset($email);
            break;
            
        default:
            $result = ['success' => false, 'message' => 'Invalid action'];
    }
    
    echo json_encode($result);
} else {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
}
?>